/********************************************************************
 LPC812 SCT demo

 This example, uses the SCT_L counter to generate a center aligned
 PWM signal with 0 to 100% duty cycle.
********************************************************************/
#include "lpc8xx.h"

extern void SCT_Init(void);
extern void SysTick_Init(void);
extern void SysTick_delay_ms(uint32_t ms);
extern void PWM_set(uint8_t val);               // set PWM duty cycle (from 0 to 100%)

int main(void)
{
  int8_t  i;

    SysTick_Init();                             // setup the SysTick timer
    SCT_Init();                                 // setup the SCTimer/PWM
	
    while (1)
    {
        for (i = 0; i < 101; i++)               // step up from 0% to 100% duty cycle
        {
            PWM_set(i);
            SysTick_delay_ms(30);
        }
        SysTick_delay_ms(500);
        for (i = 100; i >= 0; i--)              // step down from 100% to 0% duty cycle
        {
            PWM_set(i);
            SysTick_delay_ms(30);
        }
        SysTick_delay_ms(500);
    }
}
